<?php

namespace Ktane ;

/**
 * Fonctions que les contrôleurs de bombes doivent
 * pouvoir recevoir et gérer.
 */
interface Bomb
{
    /**
     * Notifie la bombe qu'un module a rencontré un événement pouvant
     * mener à l'explosion.
     *
     * Suivant l'implémentation et la configuration de la bombe, ce message
     * peut ne pas mener à explosion immédiate mais être comptabilisé pour
     * n'exploser qu'après un nombre fixé d'événements.
     */
    public function boom();

    /**
     * Notifie la bombe qu'un module a rencontré une réussite de désamorçage.
     *
     * Suivant l'implémentation et la configuration de la bombe, ce message
     * peut ne pas désarmer complètement la bombe, celle-ci attendant que
     * d'autres modules (ou tous les modules) aient notifié leur désamorçage.
     */
    public function disarmed();
}
